<?php

use Phalcon\Di\FactoryDefault\Cli as CliDI;
use Phalcon\Cli\Console as ConsoleApp;
use Phalcon\Loader;

// Using the CLI factory default services container
$di = new CliDI();


// Load the configuration file (if any)
$configFile = __DIR__ . '/config/config.php';

if (is_readable($configFile)) {
    $config = include $configFile;

    $di->set('config', $config);
}

// Load the system file (if any)
$systemFile = __DIR__ . '/config/system.php';

if (is_readable($systemFile)) {
    include $systemFile;
}

/**
 * Register the autoloader and tell it to register the tasks directory
 */
$loader = new Loader();

$loader->registerDirs(
    [
        __DIR__ . '/tasks',
    ]
);

$loader->registerNamespaces([
    'ISProject\Models' => $config->application->modelsDir,
    'ISProject'        => $config->application->libraryDir,
]);

$loader->register();


// Create a console application
$console = new ConsoleApp();

$console->setDI($di);

$di->set('db', function () use ($config) {
    
    $config = $this->getConfig();
    $db = new \Phalcon\Db\Adapter\Pdo\Mysql([
        'host'     => $config->database->host,
        'username' => $config->database->username,
        'password' => $config->database->password,
        'dbname'   => $config->database->dbname,
        'charset'  => $config->database->charset
    ]);
    
    $db->timeout = $config->database->timeout - 1;
    $db->start = time();

    $eventsManager = new \Phalcon\Events\Manager();
    $eventsManager->attach('db:beforeQuery', function ($event, $db) {
        $idle = time() - $db->start;
        if ($idle >= $db->timeout) {
            $db->connect();
            $db->start = time();
        }
    });

    $db->setEventsManager($eventsManager);

    return $db;
});

/*
    Options değerlerinin tamamının controller üzerine gönderilmesi.
*/
$di->set('options', function(){
    return (new \ISProject\Config\Config())->configParser( (new \ISProject\Models\Options())->getAllOptions() );
});

//Setup the beanstalk service
$di->set('beanstalk', function () {

    $options = $this->getOptions();

    return new \Phalcon\Queue\Beanstalk(array(
        "host"       => $options['site_ayar_general']['queue']['ip'],
        "port"       => $options['site_ayar_general']['queue']['port'],
        "persistent" => true          
    ));
});





// Console Paylaşımı
$di->setShared("console", $console);

/**
 * Process the console arguments
 */
$arguments = [];

foreach ($argv as $k => $arg) {
    if ($k === 1) {
        $arguments['task'] = $arg;
    } elseif ($k === 2) {
        $arguments['action'] = $arg;
    } elseif ($k >= 3) {
        $arguments['params'][] = $arg;
    }
}

try {
    // Handle incoming arguments
    $console->handle($arguments);
} catch (\Phalcon\Exception $e) {
    // Do Phalcon related stuff here
    // ..
    fwrite(STDERR, $e->getMessage() . PHP_EOL);
    exit(1);
} catch (\Throwable $throwable) {
    fwrite(STDERR, $throwable->getMessage() . PHP_EOL);
    exit(1);
} catch (\Exception $exception) {
    fwrite(STDERR, $exception->getMessage() . PHP_EOL);
    exit(1);
}

