<?php

namespace ISProject\Controllers;

use ISProject\Helper\JsonPage\JsonPage;
use Phalcon\Mvc\Controller;
use ISProject\Config\Config;
use ISProject\Models\Options;
use ScssPhp\ScssPhp\Compiler;

class ControllerBase extends Controller
{

    /**
     *
     * PageJSON Sınıfını barındırır.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     * @var PageJSON $page
     *
     */
    public $page = null;

    /**
     *
     * Sistem ayar bilgilerini barındırır.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     * @var array $config
     *
     */
    public $config;

    /**
     *
     * Controller çağrılmadan önce gerekli ayarlamaları yapar.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     *
     */
	public function onConstruct()
	{

		$config  = new Config();
		$this->config = $config->configParser( (new Options())->getAllOptions() );
		$this->view->setVars($config->getDefaultConfigTemplateValues());

		$this->view->setPartialsDir($config->getThemeFrontPath());
	    $this->view->setMainView($config->getThemeFrontPath() . 'master');
    	$this->view->setViewsDir($config->getThemeFrontPath() . 'pages/');

 
/*
        echo "<pre>";
        print_r( get_class_methods($this->dispatcher) );
        echo "</pre>";
        exit;
*/
        $this->page = new JsonPage();
        $this->auth->deleteErrorSuccess();
	}
    
}
