<?php
namespace ISProject\Controllers;

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

class IletisimController extends ControllerBase
{

    /**
     *
     * İletişim Saysfasını Görüntüler
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     *
     */
    public function indexAction()
    {
        if (!$this->config->general->pages->contact) {
            return $this->response->redirect('')->send();
        }

        $this->view->title    = 'İletişim';
        $this->view->iletisim = $this->page->get('iletisim');
    }

    /**
     *
     * Email gönderme işlemini yapar.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     *
     */
    public function sendEmailAction()
    {

    	$fullName = $this->request->getPost('fullName', 'trim'); 
    	$email    = $this->request->getPost('email', 'trim');
    	$messsage = $this->request->getPost('message', 'trim'); 

        if (empty($fullName) || empty($email) || empty($messsage)) {
            $this->auth->errorAdd('Lütfen tüm alanları doldurunuz.');
            $this->response->redirect('iletisim')->send();
        }

    	$mail = new PHPMailer(true);

		$mail->isSMTP(); 
		$mail->Host       = $this->config->smtp->server; 
		$mail->Timeout    = $this->config->smtp->timeout;
		$mail->SMTPAuth   = true;
		$mail->Username   = $this->config->smtp->username;
		$mail->Password   = $this->config->smtp->password;
		$mail->SMTPSecure = $this->config->smtp->security;
		$mail->Port       = $this->config->smtp->port;    
		$mail->CharSet    = "UTF-8";

		$mail->SetFrom($email, $fullName);
        $mail->addAddress($this->config->smtp->username);
		$mail->isHTML(false); 

		$mail->Subject = $fullName . ' adlı kişiden bir mesajınız var!';
		$mail->Body    = "Ad Soyad: {$fullName}\nEmail: {$email}\nMesaj: {$messsage}";

        try {
            $mail->send();
            $this->auth->successAdd('En kısa sürede sizinle iletişime geçeceğiz!');
        } catch (Exception $e) {
            $this->auth->errorAdd('İletişim Formu Bağlantısı Başarısız. Lütfen Email ayarlarınızı kontrol edin.');
        }

    	return $this->response->redirect('iletisim')->send();
    }
    
}

