<?php
namespace ISProject\Controllers;

use ISProject\Helper\FileUpload\FileUpload;
use ISProject\Helper\Utility\Utility;
use ISProject\Models\Posts;

class UrunlerController extends ControllerBase
{

    public function initialize()
    {
        
    	if (!$this->config->general->pages->products) {
    		return $this->response->redirect('')->send();
    	}

    	$this->view->title   = 'Ürünler';
        $this->view->thumbnail = $this->page->get('urunler');
    }

    public function indexAction()
    {

		$utility  = new Utility();
		$products = (new Posts())->findPostByType('product');
    	foreach ($products as $key => $product) 
    	{
    		$products[$key]->image = $utility->getPostImage($product->image, 'medium');
    	}

        $this->view->urunler = $products;
    }
    
    public function detailAction()
    {

    	if (!$this->config->general->pages->products) {
    		return $this->response->redirect('')->send();
    	}


    	$post = (new Posts())->findPostBySlug($this->dispatcher->getParam('slug'));
    	if (!isset($post->id)) {
    		return $this->response->redirect('urunler/')->send();
    	}

    	$this->view->post = $post;
    }
}

