<?php

namespace ISProject\Controllers\Admin;

use ISProject\Models\Options;
use ISProject\Models\Clients;
use ISProject\Helper\FileUpload\FileUpload;

class AyarlarController extends ControllerBase
{

    /**
     *
     * Oturum kontrolü yapılarak oturum açık ise panele yönlendirilir.
     *
     * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
     *
     */
    public function initialize()
    {

        if (!$this->auth->checkSession()) {
            return $this->response->redirect('admin/login/')->send();
        }

    }

    /**
     *
     * Kurumsal genel bakış görüntülenir.
     *
     * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
     *
     */
    public function indexAction()
    {
    	$this->view->smtp = $this->config->smtp;
    }

    /**
     *
     * Tema Rengi Alanının işlemleri buradan yapılır.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     *
     */
    public function colorUpdateAction()
    {

        if ($this->request->getPost('save') === null) {
            return $this->response->redirect('admin/ayarlar/')->send();
        }

        $this->config->general->theme->color = mb_substr($this->request->getPost('themeColor', 'trim'), 0, CMS_MIN_CHARACTER);

        $options = new Options();
        $options->updateOption('general', json_encode($this->config->general));

        $this->auth->successAdd('Tema rengi başarıyla değiştirildi.');
        return $this->response->redirect('admin/ayarlar/')->send();
    }

    /**
     *
     * LOGO Alanının işlemleri buradan yapılır.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     *
     */
    public function logoUpdateAction()
    {

        if ($this->request->getPost('save') === null) {
            return $this->response->redirect('admin/ayarlar/')->send();
        }

        $fileupload = new FileUpload();
       	if (!$fileupload->checkFile('image')) {
       		$this->auth->errorAdd('Lütfen logo seçin.');
            return $this->response->redirect('admin/ayarlar/')->send();
      	}

        $response = $fileupload->uploadImage('image');
        if ($response['error']) {
       		$this->auth->errorAdd('Yükleme Hatası: ' . $response['msg']);
            return $this->response->redirect('admin/ayarlar/')->send();
        }

        if (isset($this->config->general->theme->logo->path)) {
        	$fileupload->deleteImage($this->config->general->theme->logo);
        }

        $this->config->general->theme->logo = $response['data'];

        $options = new Options();
        $options->updateOption('general', json_encode($this->config->general));
        $this->auth->successAdd('Logo başarıyla değiştirildi.');
        return $this->response->redirect('admin/ayarlar/')->send();
    }

    /**
     *
     * Menü Alanının işlemleri buradan yapılır.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     *
     */
    public function pageUpdateAction()
    {

        if ($this->request->getPost('save') === null) {
            return $this->response->redirect('admin/ayarlar/')->send();
        }

        foreach ($this->config->general->pages as $pageKey => $pageValue) {
        	$this->config->general->pages->{$pageKey}->active = $this->request->getPost($pageKey) === null ? false : true;
        }

        $options = new Options();
        $options->updateOption('general', json_encode($this->config->general));

        $this->auth->successAdd('Menü başarıyla değiştirildi.');
        return $this->response->redirect('admin/ayarlar/')->send();
    }

    /**
     *
     * SMTP Alanının işlemleri buradan yapılır.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     *
     */
    public function smtpUpdateAction()
    {

        if ($this->request->getPost('save') === null) {
            return $this->response->redirect('admin/ayarlar/')->send();
        }

		$this->config->smtp->server   = mb_substr($this->request->getPost('server', 'trim'), 0, CMS_MIN_CHARACTER);
		$this->config->smtp->username = mb_substr($this->request->getPost('username', 'trim'), 0, CMS_MIN_CHARACTER);
		$this->config->smtp->password = mb_substr($this->request->getPost('password', 'trim'), 0, CMS_MIN_CHARACTER);
		$this->config->smtp->port     = (int) $this->request->getPost('port', 'trim');
		$this->config->smtp->timeout  = (int) $this->request->getPost('timeout', 'trim');
		$this->config->smtp->security = $this->request->getPost('security') === 'tls' ? 'tls' : 'ssl';

        $options = new Options();
        $options->updateOption('smtp', json_encode($this->config->smtp));

        $this->auth->successAdd('SMTP Ayarları başarıyla değiştirildi.');
        return $this->response->redirect('admin/ayarlar/')->send();
    }

    /**
     *
     * Şifre Değiştirme Alanının işlemleri buradan yapılır.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     *
     */
    public function passwordUpdateAction()
    {

        if ($this->request->getPost('save') === null) {
            return $this->response->redirect('admin/ayarlar/')->send();
        }

        if ($this->auth->uniqueLoginPassword($this->request->getPost('oldPassword', 'trim')) !== $this->auth->client->password) {
            $this->auth->errorAdd('Eski şifreniz yanlış.');
            return $this->response->redirect('admin/ayarlar/')->send();
        }       

        $newPassword       = $this->request->getPost('newPassword', 'trim');
        $newPasswordRepeat = $this->request->getPost('newPasswordRepeat', 'trim');
        if ($newPassword !== $newPasswordRepeat) {
            $this->auth->errorAdd('Girdiğiniz şifreler birbir ile uyuşmuyor.');
            return $this->response->redirect('admin/ayarlar/')->send();
        }

        if (strlen($newPassword) < 6) 
        {
            $this->auth->errorAdd('Şifreniz en az 6 karakter olmalıdır.');
            return $this->response->redirect('admin/ayarlar/')->send();
        }

        $clients = new Clients();
        $clients->updateUser($this->auth->client->id, array('password' => $this->auth->uniqueLoginPassword($newPassword)));

        $this->auth->successAdd('Hesap şifreniz başarıyla değiştirildi.');
        return $this->response->redirect('admin/ayarlar/')->send();
    }

    /**
     *
     * Footer Kurumsal Alanının işlemleri buradan yapılır.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     *
     */
    public function kurumsalUpdateAction()
    {

        if ($this->request->getPost('save') === null) {
            return $this->response->redirect('admin/ayarlar/')->send();
        }

        $this->config->general->company->kurumsal = mb_substr($this->request->getPost('kurumsal', 'trim'), 0, CMS_MEDIUM_CHARACTER);

        $options = new Options();
        $options->updateOption('general', json_encode($this->config->general));

        $this->auth->successAdd('Footer Kurumsal yazısı başarıyla değiştirildi.');
        return $this->response->redirect('admin/ayarlar/')->send();
    }

    /**
     *
     * Seo Description Alanının işlemleri buradan yapılır.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     *
     */
    public function seoUpdateAction()
    {

        if ($this->request->getPost('save') === null) {
            return $this->response->redirect('admin/ayarlar/')->send();
        }

        $this->config->general->seo->description = mb_substr($this->request->getPost('seoDescription', 'trim'), 0, CMS_MIN_CHARACTER);

        $options = new Options();
        $options->updateOption('general', json_encode($this->config->general));

        $this->auth->successAdd('Seo Açıklama başarıyla değiştirildi.');
        return $this->response->redirect('admin/ayarlar/')->send();
    }

}
