<?php

namespace ISProject\Controllers\Admin;

class GaleriController extends ControllerBase
{

    /**
     *
     * Oturum kontrolü yapılarak oturum açık ise panele yönlendirilir.
     *
     * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
     *
     */
    public function initialize()
    {
        if (!$this->auth->checkSession()) {
            return $this->response->redirect('admin/login/')->send();
        }
        
        if (!$this->page->check('galeri')) {
            return $this->response->redirect('admin/')->send();
        }

        $this->view->page = $this->page->get('galeri');
    }

    /**
     *
     * Kurumsal genel bakış görüntülenir.
     *
     * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
     *
     */
    public function indexAction()
    {

        
    }

    /**
     *
     * Kurumsal Alananının işlemleri buradan yapılır.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     *
     */
    public function galeriAction()
    {

        $galeri = $this->request->getPost('galeri');
        if ($galeri === null) {
            return $this->response->redirect('admin/')->send();
        }

        if ($this->request->getPost('add') !== null) 
        {
            $this->page->addData('galeri', 'galeri', array(
                'title'       => '', 
                'active'      => true,
                'image'       => array(
                    'medium' => array('width' => 350, 'height' => 250),
                    'small'  => array('width' => 250, 'height' => 250)
                )
            ));
            $this->auth->successAdd('Yeni galeri başarıyla eklendi.');
        }
        else if ($this->request->getPost('update') !== null) 
        {
            $response = $this->page->update('galeri', 'galeri', array(
                    'dataId'      => $galeri,
                    'title'       => mb_substr($this->request->getPost('title', 'trim'), 0, CMS_MIN_CHARACTER),
                    'active'      => $this->request->getPost('aktifpasif') == 'on' ? true : false,
                    'image'       => array(
                        'medium' => array('width' => 350, 'height' => 250),
                        'small'  => array('width' => 250, 'height' => 250)
                    )
                )
            );
            if ($response['error']) {
                $this->auth->errorAdd($response['msg']);
            }else{
                $this->auth->successAdd('Galeri başarıyla güncellendi.');
            }
        }
        else if($this->request->getPost('delete') !== null)
        {
            $this->page->delete('galeri', 'galeri', $galeri);
            $this->auth->successAdd('Galeri başarıyla silindi.');
        }

        return $this->response->redirect('admin/galeri/')->send();
    }

}

