<?php

namespace ISProject\Controllers\Admin;

class HizmetlerController extends ControllerBase
{

    /**
     *
     * Oturum kontrolü yapılarak oturum açık ise panele yönlendirilir.
     *
     * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
     *
     */
    public function initialize()
    {
        if (!$this->auth->checkSession()) {
            return $this->response->redirect('admin/login/')->send();
        }
        
        if (!$this->page->check('hizmetler')) {
            return $this->response->redirect('admin/')->send();
        }

        $this->view->page = $this->page->get('hizmetler');
    }

    /**
     *
     * Kurumsal genel bakış görüntülenir.
     *
     * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
     *
     */
    public function indexAction()
    {


    }

    /**
     *
     * Kurumsal Alananının işlemleri buradan yapılır.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     *
     */
    public function hizmetlerAction()
    {

        $hizmetId = $this->request->getPost('hizmet');
        if ($hizmetId === null) {
            return $this->response->redirect('admin/')->send();
        }

        if ($this->request->getPost('add') !== null) 
        {
            $this->page->addData('hizmetler', 'hizmetler', array(
                'title'       => '', 
                'description' => '', 
                'active'      => true,
                'image'       => array(
                    'large'  => array('width' => 350, 'height' => 250),
                    'medium' => array('width' => 250, 'height' => 250)
                )
            ));
            $this->auth->successAdd('Yeni hizmet başarıyla eklendi.');
        }
        else if ($this->request->getPost('update') !== null) 
        {
            $this->page->update('hizmetler', 'hizmetler', array(
                    'dataId'      => $hizmetId,
                    'title'       => mb_substr($this->request->getPost('title', 'trim'), 0, CMS_MIN_CHARACTER),
                    'description' => mb_substr($this->request->getPost('description', 'trim'), 0, CMS_MIN_CHARACTER),
                    'active'      => $this->request->getPost('aktifpasif') == 'on' ? true : false,
                    'image'       => array(
                        'large'  => array('width' => 350, 'height' => 250),
                        'medium' => array('width' => 250, 'height' => 250)
                    )
                )
            );
            if ($response['error']) {
                $this->auth->errorAdd($response['msg']);
            }else{
                $this->auth->successAdd('Hizmetler başarıyla güncellendi.');
            }            
        }
        else if($this->request->getPost('delete') !== null)
        {
            $this->page->delete('hizmetler', 'hizmetler', $hizmetId);
            $this->auth->successAdd('Hizmet başarıyla silindi.');
        }

        return $this->response->redirect('admin/hizmetler/')->send();
    }

}

