<?php

namespace ISProject\Controllers\Admin;

use ISProject\Models\Options;

class IletisimController extends ControllerBase
{

    /**
     *
     * Oturum kontrolü yapılarak oturum açık ise panele yönlendirilir.
     *
     * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
     *
     */
    public function initialize()
    {
        
        if (!$this->auth->checkSession()) {
            return $this->response->redirect('admin/login/')->send();
        }
        
        if (!$this->page->check('iletisim')) {
            return $this->response->redirect('admin/')->send();
        }

        $this->view->page = $this->page->get('iletisim');      
    }

    /**
     *
     * Genel bakış görüntülenir.
     *
     * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
     *
     */
    public function indexAction()
    {

        
    }

    /**
     *
     * Harita alanı işlemleri buradan yapılır.
     *
     * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
     *
     */
    public function mapAction()
    {

        if ($this->request->getPost('save') === null) {
            return $this->response->redirect('admin/iletisim/')->send();
        }

        $mapOldData = $mapData = mb_substr($this->request->getPost('mapData', 'trim'), 0, CMS_MEDIUM_CHARACTER);
        if (preg_match('@<iframe(.*?)src="(.*?)"(.*?)>@si', $mapOldData, $output)) 
        {
            $mapData = trim(htmlspecialchars($output[2]));
        }
        else if (preg_match('@<embed(.*?)src="(.*?)"(.*?)>@si', $mapOldData, $output)) 
        {
            $mapData = trim(htmlspecialchars($output[2]));
        }

        $this->config->general->contact->map->iframe = $mapOldData;
        $this->config->general->contact->map->url    = $mapData;
        $this->config->general->contact->map->active = $this->request->getPost('aktifpasif') == 'on';

        $options = new Options();
        $options->updateOption('general', json_encode($this->config->general));

        $this->auth->successAdd('Harita Alanı başarıyla kaydedildi.');
        return $this->response->redirect('admin/iletisim/')->send();
    }

    /**
     *
     * İletişim alanı işlemleri buradan yapılır.
     *
     * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
     *
     */
    public function contactAction()
    {

        if ($this->request->getPost('save') === null) {
            return $this->response->redirect('admin/iletisim/')->send();
        }
        
        $this->config->general->company->name     = mb_substr($this->request->getPost('companyname', 'trim'), 0, CMS_MIN_CHARACTER);
        $this->config->general->contact->address  = mb_substr($this->request->getPost('address', 'trim'), 0, CMS_MIN_CHARACTER);
        $this->config->general->contact->email    = mb_substr($this->request->getPost('email', 'trim'), 0, CMS_MIN_CHARACTER);
        $this->config->general->contact->phone    = mb_substr($this->request->getPost('phone', 'trim'), 0, CMS_MIN_CHARACTER);
        $this->config->general->contact->gsm      = mb_substr($this->request->getPost('gsm', 'trim'), 0, CMS_MIN_CHARACTER);
        $this->config->general->contact->whatsapp = mb_substr($this->request->getPost('whatsapp', 'trim'), 0, CMS_MIN_CHARACTER);

        $options = new Options();
        $options->updateOption('general', json_encode($this->config->general));

        $this->auth->successAdd('İletişim Alanı başarıyla kaydedildi.');
        return $this->response->redirect('admin/iletisim/')->send();
    }

    /**
     *
     * Sosyal medya alanı işlemleri buradan yapılır.
     *
     * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
     *
     */
    public function socialAction()
    {

        if ($this->request->getPost('save') === null) {
            return $this->response->redirect('admin/iletisim/')->send();
        }
        
        $this->config->general->social->facebook  = mb_substr($this->request->getPost('facebook', 'trim'), 0, CMS_MIN_CHARACTER);
        $this->config->general->social->twitter   = mb_substr($this->request->getPost('twitter', 'trim'), 0, CMS_MIN_CHARACTER);
        $this->config->general->social->youtube   = mb_substr($this->request->getPost('youtube', 'trim'), 0, CMS_MIN_CHARACTER);
        $this->config->general->social->instagram = mb_substr($this->request->getPost('instagram', 'trim'), 0, CMS_MIN_CHARACTER);

        $options = new Options();
        $options->updateOption('general', json_encode($this->config->general));

        $this->auth->successAdd('Sosyal Medya Alanı başarıyla kaydedildi.');
        return $this->response->redirect('admin/iletisim/')->send();
    }

}

