<?php

namespace ISProject\Controllers\Admin;

use ISProject\Helper\FileUpload\FileUpload;

class IndexController extends ControllerBase
{

    /**
     *
     * Oturum kontrolü yapılarak yetkililer dışındakiler giremez.
     *
     * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
     *
     */
    public function initialize()
    {

        if (!$this->auth->checkSession()) {
            return $this->response->redirect('admin/login/')->send();
        }
        
        if (!$this->page->check('index')) {
            return $this->response->redirect('admin/')->send();
        }

        $this->view->page = $this->page->get('index');
    }

    /**
     *
     * Admin Paneli genel bakış bu bölümden görüntülenir.
     *
     * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
     *
     */
    public function indexAction()
    {

    }

    /**
     *
     * NedenBiz Bölümünün işlemlerini yapar.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     *
     */
    public function whymeAction()
    {

        if ($this->request->getPost('whyme') === null) {
            return $this->response->redirect('admin/')->send();
        }

        if ($this->request->getPost('update') !== null) 
        {
            $response = $this->page->update('index', 'whyme', array(
                    'title'       => mb_substr($this->request->getPost('title', 'trim'), 0, CMS_MIN_CHARACTER),
                    'description' => mb_substr($this->request->getPost('description', 'trim'), 0, CMS_MEDIUM_CHARACTER),
                    'active'      => $this->request->getPost('aktifpasif') == 'on' ? true : false,
                )
            );
            if ($response['error']) {
                $this->auth->errorAdd($response['msg']);
            }else{
                $this->auth->successAdd('NedenBiz başarıyla güncellendi.');
            }            
        }
        else
        {
            $this->page->update('index', 'whyme', array('title' => '', 'description' => '', 'active' => false));
            $this->auth->successAdd('NedenBiz başarıyla temizlendi.');           
        }

        return $this->response->redirect('admin/')->send();
    }

    /**
     *
     * Banner Bölümünün işlemlerini yapar.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     *
     */
    public function bannerAction()
    {

        $bannerId = $this->request->getPost('banner');
        if ($bannerId === null) {
            return $this->response->redirect('admin/')->send();
        }

        if ($this->request->getPost('update') !== null) 
        {
            $response = $this->page->update('index', 'banner', array(
                    'dataId'      => $bannerId,
                    'title'       => mb_substr($this->request->getPost('title', 'trim'), 0, CMS_MIN_CHARACTER),
                    'description' => mb_substr($this->request->getPost('description', 'trim'), 0, CMS_MIN_CHARACTER),
                    'active'      => $this->request->getPost('aktifpasif') == 'on' ? true : false,
                    'image'       => array(
                        'large'  => array('width' => 1370, 'height' => 450),
                        'medium' => array('width' => 250, 'height' => 250)
                    )
                )
            );
            if ($response['error']) {
                $this->auth->errorAdd($response['msg']);
            }else{
                $this->auth->successAdd('Banner başarıyla güncellendi.');
            }
        }
        else
        {
            $this->page->update('index', 'banner', array('deleteImage' => true, 'dataId' => $bannerId, 'title' => '', 'description' => '', 'active' => false));
            $this->auth->successAdd('Banner başarıyla temizlendi.');           
        }

        return $this->response->redirect('admin/')->send();
    }

    /**
     *
     * Duyurular Bölümünün işlemlerini yapar.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     *
     */
    public function announcementAction()
    {

        $announcementId = $this->request->getPost('announcement');
        if ($announcementId === null) {
            return $this->response->redirect('admin/')->send();
        }

        if ($this->request->getPost('update') !== null) 
        {
            $response = $this->page->update('index', 'announcements', array(
                    'dataId'      => $announcementId,
                    'title'       => mb_substr($this->request->getPost('title', 'trim'), 0, CMS_MIN_CHARACTER),
                    'description' => mb_substr($this->request->getPost('description', 'trim'), 0, CMS_MEDIUM_CHARACTER),
                    'active'      => $this->request->getPost('aktifpasif') == 'on' ? true : false,
                    'image'       => array(
                        'large'  => array('width' => 600, 'height' => 400), 
                        'medium' => array('width' => 250, 'height' => 250), 
                        'small'  => array('width' => 80, 'height' => 80)
                    )
                )
            );
            if ($response['error']) {
                $this->auth->errorAdd($response['msg']);
            }else{
                $this->auth->successAdd('Duyuru başarıyla güncellendi.');
            }            
        }
        else
        {
            $this->page->update('index', 'announcements', array('deleteImage' => true, 'dataId' => $announcementId, 'title' => '', 'description' => '', 'active' => false));
            $this->auth->successAdd('Duyuru başarıyla temizlendi.');           
       }

        return $this->response->redirect('admin/')->send();
    }

    /**
     *
     * Thumbnail güncelleme işlemlerini yapar.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     *
     */
    public function thumbnailAction()
    {


        $controller = $this->request->getPost('page', 'trim');
        if ($this->request->getPost('save') === null) {
            return $this->response->redirect('admin/' . $controller . '/')->send();
        }

        if (!in_array($controller, array('kurumsal', 'referanslar', 'hizmetler', 'galeri', 'urunler', 'iletisim'))) {
            return $this->response->redirect('admin/')->send();
        }

        $fileupload = new FileUpload();
        if ($fileupload->checkFile('image')) 
        {

            $fileupload->setImageResize(array(
                'large'  => array('width' => 1370, 'height' => 200),
                'small' => array('width' => 250, 'height' => 250)
            ));

            $response = $fileupload->uploadImage('image');
            if ($response['error']) {
                $this->auth->errorAdd('Yükleme Hatası: ' . $response['msg']);
                return $this->response->redirect('admin/' . $controller . '/')->send();
            }    

            $response = $this->page->update($controller, 'thumbnail', array('deleteThumbnail' => true, 'selected' => 'uploaded', 'uploaded' => $response['data']));
        }else if ($this->request->getPost('imageId', 'trim') !== 'uploaded') {
            $response = $this->page->update($controller, 'thumbnail', array('deleteThumbnail' => true, 'selected' => $this->request->getPost('imageId', 'trim')));
        }

        if (isset($response))
        {
            if ($response['error']) {
                $this->auth->errorAdd($response['msg']);
            }else{
                $this->auth->successAdd(ucfirst($controller) . ' başarıyla güncellendi.');
            }  
        }

        return $this->response->redirect('admin/' . $controller . '/')->send();
    }

}

