<?php

namespace ISProject\Controllers\Admin;

class KurumsalController extends ControllerBase
{

    /**
     *
     * Oturum kontrolü yapılarak oturum açık ise panele yönlendirilir.
     *
     * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
     *
     */
    public function initialize()
    {
        if (!$this->auth->checkSession()) {
            return $this->response->redirect('admin/login/')->send();
        }
        
        if (!$this->page->check('kurumsal')) {
            return $this->response->redirect('admin/')->send();
        }

        $this->view->page = $this->page->get('kurumsal');
    }

    /**
     *
     * Kurumsal genel bakış görüntülenir.
     *
     * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
     *
     */
    public function indexAction()
    {
        
    }

    /**
     *
     * Kurumsal Alananının işlemleri buradan yapılır.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     *
     */
    public function kurumsalAction()
    {

        if ($this->request->getPost('kurumsal') === null) {
            return $this->response->redirect('admin/')->send();
        }

        if ($this->request->getPost('update') !== null) 
        {
            $response = $this->page->update('kurumsal', 'kurumsal', array(
                    'title'       => mb_substr($this->request->getPost('title', 'trim'), 0, CMS_MIN_CHARACTER),
                    'description' => mb_substr($this->request->getPost('description', 'trim'), 0, CMS_LARGE_CHARACTER),
                    'active'      => $this->request->getPost('aktifpasif') == 'on' ? true : false,
                )
            );
            if ($response['error']) {
                $this->auth->errorAdd($response['msg']);
            }else{
                $this->auth->successAdd('Kurumsal başarıyla güncellendi.');
            }            
        }
        else
        {
            $this->page->update('kurumsal', 'kurumsal', array('title' => '', 'description' => '', 'active' => false));
            $this->auth->successAdd('Kurumsal başarıyla temizlendi.');
        }

        return $this->response->redirect('admin/kurumsal/')->send();
    }

    /**
     *
     * Vizyon Alananının işlemleri buradan yapılır.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     *
     */
    public function vizyonAction()
    {

        if ($this->request->getPost('vizyon') === null) {
            return $this->response->redirect('admin/')->send();
        }

        if ($this->request->getPost('update') !== null) 
        {
            $response = $this->page->update('kurumsal', 'vizyon', array(
                    'title'       => mb_substr($this->request->getPost('title', 'trim'), 0, CMS_MIN_CHARACTER),
                    'description' => mb_substr($this->request->getPost('description', 'trim'), 0, CMS_MEDIUM_CHARACTER),
                    'active'      => $this->request->getPost('aktifpasif') == 'on' ? true : false,
                )
            );
            if ($response['error']) {
                $this->auth->errorAdd($response['msg']);
            }else{
                $this->auth->successAdd('Vizyon başarıyla güncellendi.');
            }            
        }
        else
        {
            $this->page->update('kurumsal', 'vizyon', array('title' => '', 'description' => '', 'active' => false));
            $this->auth->successAdd('Vizyon başarıyla temizlendi.');            
        }

        return $this->response->redirect('admin/kurumsal/')->send();
    }

    /**
     *
     * Misyon Alananının işlemleri buradan yapılır.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     *
     */
    public function misyonAction()
    {

        if ($this->request->getPost('misyon') === null) {
            return $this->response->redirect('admin/')->send();
        }

        if ($this->request->getPost('update') !== null) 
        {
            $response = $this->page->update('kurumsal', 'misyon', array(
                    'title'       => mb_substr($this->request->getPost('title', 'trim'), 0, CMS_MIN_CHARACTER),
                    'description' => mb_substr($this->request->getPost('description', 'trim'), 0, CMS_MEDIUM_CHARACTER),
                    'active'      => $this->request->getPost('aktifpasif') == 'on' ? true : false,
                )
            );
            if ($response['error']) {
                $this->auth->errorAdd($response['msg']);
            }else{
                $this->auth->successAdd('Misyon başarıyla güncellendi.');
            }            
        }
        else
        {
            $this->page->update('kurumsal', 'misyon', array('title' => '', 'description' => '', 'active' => false));
            $this->auth->successAdd('Misyon başarıyla silindi.');
        }

        return $this->response->redirect('admin/kurumsal/')->send();
    }

}

