<?php

namespace ISProject\Controllers\Admin;

use ISProject\Config\Config;

class LoginController extends ControllerBase
{

    /**
     *
     * Oturum kontrolü yapılarak oturum açık ise panele yönlendirilir.
     *
     * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
     *
     */
    public function initialize()
    {
        
        if ($this->auth->checkSession()) {
            return $this->response->redirect('admin/')->send();
        }

    }

    /**
     *
     * Admin girişi bu bölümden görüntülenir.
     *
     * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
     *
     */
    public function indexAction()
    {
        $this->setMainView('login');
    }

    /**
     *
     * Admin girişi bu bölümden görüntülenir.
     *
     * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
     *
     */
    public function loginAction()
    {

        if ($this->request->getPost('login') === null) {
           return $this->response->redirect('admin/login/')->send();
        }

        $response = $this->auth->userLogin($this->request->getPost('email', 'trim'), $this->request->getPost('password', 'trim'));
        if ($response['error']) {
            $this->auth->errorAdd('Email adresiniz veya şifreniz hatalı.');
            return $this->response->redirect('admin/login/')->send();
        }

       return $this->response->redirect('admin/')->send();
    }

}

