<?php

namespace ISProject\Controllers\Admin;

class ReferanslarController extends ControllerBase
{

    /**
     *
     * Oturum kontrolü yapılarak oturum açık ise panele yönlendirilir.
     *
     * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
     *
     */
    public function initialize()
    {
        if (!$this->auth->checkSession()) {
            return $this->response->redirect('admin/login/')->send();
        }
        
        if (!$this->page->check('referanslar')) {
            return $this->response->redirect('admin/')->send();
        }

        $this->view->page = $this->page->get('referanslar');
    }

    /**
     *
     * Kurumsal genel bakış görüntülenir.
     *
     * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
     *
     */
    public function indexAction()
    {

        
    }

    /**
     *
     * Kurumsal Alananının işlemleri buradan yapılır.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     *
     */
    public function referanslarAction()
    {

        $referansId = $this->request->getPost('referans');
        if ($referansId === null) {
            return $this->response->redirect('admin/')->send();
        }

        if ($this->request->getPost('add') !== null) 
        {
            $this->page->addData('referanslar', 'referanslar', array(
                'title'       => '', 
                'active'      => true,
                'image'       => array(
                    'medium' => array('width' => 350, 'height' => 200),
                    'small'  => array('width' => 250, 'height' => 250)
                )
            ));
            $this->auth->successAdd('Referans başarıyla eklendi.');
       }
        else if ($this->request->getPost('update') !== null) 
        {
            $response = $this->page->update('referanslar', 'referanslar', array(
                    'dataId'      => $referansId,
                    'title'       => mb_substr($this->request->getPost('title', 'trim'), 0, CMS_MIN_CHARACTER),
                    'active'      => $this->request->getPost('aktifpasif') == 'on' ? true : false,
                    'image'       => array(
                        'medium' => array('width' => 350, 'height' => 200),
                        'small'  => array('width' => 250, 'height' => 250)
                    )
                )
            );
            if ($response['error']) {
                $this->auth->errorAdd($response['msg']);
            }else{
                $this->auth->successAdd('Referans başarıyla güncellendi.');
            }            
        }
        else if($this->request->getPost('delete') !== null)
        {
            $this->page->delete('referanslar', 'referanslar', $referansId);
            $this->auth->successAdd('Referans başarıyla silindi.');
        }

        return $this->response->redirect('admin/referanslar/')->send();
    }

}

