<?php
namespace ISProject\Config;

use ISProject\Helper\Utility\Utility;

class Config extends \Phalcon\Mvc\Controller
{

    /**
     *
     * Sistem ayarlarını depolar.
     *
     * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
     * @param array $config
     *
     */
    private static $config;

    /**
     *
     * Görünüm klasörünü barındırır.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     * @var string $viewDirectory
     *
     */
    private static $viewDirectory;

    /**
     *
     * Temaya gönderilecek default değişkenler
     *
     * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
     * @return array 
     *
     */
    public function getDefaultConfigTemplateValues()
    {

        $pageID = intval($this->request->getQuery('pid'));
        if ($pageID <= 0) {
            $pageID = 1;
        }

        self::$viewDirectory = $this->view->getViewsDir();

        $router = $this->pageUrl(self::$config->site_url);

        return array(
            'client' => $this->auth->client,
            'site'   => (object)array(
                'logo'       => $this->getLogo(self::$config->general->theme->logo),
                'url'        => self::$config->site_url,
                'general'    => self::$config->general,
                'error'      => $this->auth->errors,
                'success'    => $this->auth->success,
                'page'       => $router['url'],
                'params'     => $router['params'],
                'pageid'     => $pageID,
                'controller' => $this->router->getControllerName(),
                'admin'      => (object)array(
                    'url'   => self::$config->site_url . 'admin/', 
                    'theme' => (object)array(
                        'url' => $this->getThemeAdminUrl(),
                    )
                ),
                'theme'      => (object)array(
                    'url' => $this->getThemeFrontUrl(),
                ),
                'charachter' => (object)array(
                    'min'    => CMS_MIN_CHARACTER,
                    'medium' => CMS_MEDIUM_CHARACTER,
                    'large'  => CMS_LARGE_CHARACTER,
                ),
            ),
        );

    }

    /**
     *
     * Logo Bilgilerini döner.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     *
     */
    public function getLogo($image)
    {
        $utility = new Utility();
        $imageUrl = $utility->getImageUrl($image->path, $image->images->original);
        return (object) array('exists' => !($imageUrl === false), 'url' => $imageUrl);
    }


    /**
     *
     * Sistem Ayarlarını döner.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     * @return array 
     *
     */
    public static function getConfig()
    {
        return self::$config;
    }

    /**
     *
     * Tema klasör Url Adresini verir.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     * @return string 
     *
     */
    public function getThemeFrontUrl()
    {
        return self::$config->site_url . self::getAssetsFrontPath();
    }

    /**
     *
     * Tema klasör Url Adresini verir.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     * @return string 
     *
     */
    public static function getAssetsFrontPath($basePath = false, $public = true)
    {

        $path = '';
        if ($basePath) {
            $path .= BASE_PATH;
        }

        if ($public) {
            $path .= '/public';
        }

        return $path . '/assets/front/' . CMS_FRONTEND_FOLDER . '/';
    }

    /**
     *
     * Tema klasör yolunu verir.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     * @return string 
     *
     */
    public static function getThemeFrontPath()
    {

        return self::$viewDirectory . 'front/' . CMS_FRONTEND_FOLDER . '/';
    }

    /**
     *
     * Admin Tema klasör Url Adresini verir.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     * @return string 
     *
     */
    public static function getThemeAdminUrl()
    {
        return self::$config->site_url . self::getAssetsAdminPath();
    }

    /**
     *
     * Admin Tema klasör Url Adresini verir.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     * @return string 
     *
     */
    public static function getAssetsAdminPath($basePath = false)
    {
        return ($basePath ? BASE_PATH : '') .'/public/assets/admin/' . CMS_ADMIN_FOLDER . '/';
    }

    /**
     *
     * Admin Tema klasör yolunu verir.
     *
     * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
     * @return string 
     *
     */
    public static function getThemeAdminPath()
    {
        return self::$viewDirectory . 'admin/' . CMS_ADMIN_FOLDER . '/';
    }

    /**
     *
     * Options tablosundaki verileri parse eder.
     *
     * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
     * @param string $options
     * @return array 
     *
     */
    public function configParser($options)
    {

        $configs = new \StdClass();
        foreach ($options as $option) {
            $optionValue = json_decode($option->option_value);
            $configs->{$option->option_name} = is_object($optionValue) ? $optionValue : $option->option_value;
        }

        return self::$config = $configs;

    }

    /**
     *
     * Sayfa url adresini parçalar ve döndürür.
     *
     * @author İsmail Satilmiş <ismaiil_0234@hotmail.com>
     * @param string $url
     * @return array 
     *
     */
    private function pageUrl($url)
    {

        $querys = $this->request->getQuery();

        $continueURL = '';
        if (isset($querys['_url'])) {
            $continueURL = $querys['_url'];
            if ($querys['_url'][0] == '/') {
                $continueURL = substr($continueURL , 1 , strlen($continueURL) - 1);
            }
        }

        unset($querys['_url']);

        $params = array();
        foreach ($querys as $key => $value) {
            array_push($params , $key . '=' . $value);
        }

        return array('url' => $url . $continueURL, 'params' => $params);

    }

}