<?php 

namespace ISProject\Helper\JsonPage;

use ISProject\Helper\FileUpload\FileUpload;
use ISProject\Helper\Utility\Utility;
use ISProject\Config\Config;
use ISProject\Models\Pages;

Class JsonPage extends JsonFormatter
{

	/**
	 *
	 * Sayfaların Ham önbelleği
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @var array $pages
	 *
	 */
	protected $simplePages = array();

	/**
	 *
	 * Sayfaların Formatlanmış önbelleği
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @var array $pages
	 *
	 */
	protected $pages = array();

	/**
	 *
	 * Dosya yükleme sınıfı örneği
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @var FileUpload $fileupload
	 *
	 */
	protected $fileupload;

	/**
	 *
	 * Sınıf başlatıldığına gerekli ayarlamaları yapar.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 *
	 */
	public function __construct()
	{
		$this->fileupload = new FileUpload();
	}

	/**
	 *
	 * Veriabanından sayfayı çekme
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param string $pageName
	 * @return array 
	 *
	 */
	public function get($pageName, $simple = false)
	{

		if (!$simple && isset($this->pages[$pageName])) {
			return $this->pages[$pageName];
		}

		if ($simple && isset($this->simplePages[$pageName])) {
			return $this->simplePages[$pageName];
		}

		$page = (new Pages())->findPage($pageName);
		if (!isset($page->id) ) {
			$this->pages[$pageName] = false;
			$this->simplePages[$pageName] = false;
		}

		$this->simplePages[$pageName] = json_decode($page->pageData, true);
		if ($this->simplePages[$pageName] == null) {
			$this->simplePages[$pageName] = false;
		}

		$this->pages[$pageName] = $this->pageFormat(json_decode($page->pageData));
		return $this->get($pageName, $simple);
	}

	/**
	 *
	 * Sayfanın varlığını kontrol eder.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param string $pageName
	 * @return boolean 
	 *
	 */
	public function check($pageName)
	{
		if (!isset($this->simplePages[$pageName])) {
			$this->get($pageName);
		}
		return !($this->simplePages[$pageName] === false);
	}

	/**
	 *
	 * Sayfaların belirli içeriğini siler.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param string $pageName
	 * @param string|array $optionDataOne
	 * @param int $dataId
	 *
	 */
	public function delete($pageName, $section, $dataId = null)
	{
		if (!$this->check($pageName)) {
			return false;
		}

		$this->update($pageName, $section, array('dataId' => $dataId, 'deleteImage' => true));

		if ($this->checkSection() && $this->checkDataId()) 
		{
			$itemData = reset($this->simplePages[$pageName][$section]);
			if (count($this->simplePages[$pageName][$section]) == 1) 
			{
				foreach ($itemData as $itemKey => $itemValue) 
				{
					if ($itemKey === "active") 
					{
						$itemData[$itemKey] = 2;
					}
					else if ($itemKey === "image") 
					{
						$itemData[$itemKey] = array();
					}
					else
					{
						$itemData[$itemKey] = '';
					}
				}
				$this->addData($pageName, $section, $itemData);
			}

			unset($this->simplePages[$pageName][$section][$dataId]);
			$this->simplePages[$pageName][$section] = array_values($this->simplePages[$pageName][$section]);

		}else if($this->checkSection()){
			unset($this->simplePages[$pageName][$section]);
		}

		$page = new Pages();
        $page->updatePage($pageName, json_encode($this->simplePages[$pageName]));
	}

	/**
	 *
	 * Sayfalara yeni içerikler ekler.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param string $pageName
	 * @param string $section
	 * @param array $data
	 *
	 */
	public function addData($pageName, $section, $data)
	{
		if (!$this->check($pageName)) {
			return false;
		}

		$data['dataId'] = $this->getLastDataId($this->simplePages[$pageName][$section]);
		$this->update($pageName, $section, $data);
	}

	/**
	 *
	 * Sayfaları güncellemek için kullanılır.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param string $pageName
	 * @param string $section
	 * @param array $data
	 *
	 */
	public function update($pageName, $section, $data)
	{

		if (!$this->check($pageName)) {
			return array('error' => false);
		}

		$this->setData($data);
		$this->setSection($section);

		$section = $this->getSection();
		$dataId  = $this->getDataId();

		if ($this->checkSection() && $this->checkDataId()) {
			$this->simplePages[$pageName][$section][$dataId] = $this->setPageData($this->simplePages[$pageName][$section][$dataId]);
		}else if($this->checkSection()){
			$this->simplePages[$pageName][$section] = $this->setPageData($this->simplePages[$pageName][$section]);
		}

		$page = new Pages();
        $page->updatePage($pageName, json_encode($this->simplePages[$pageName]));

        if ($this->isError()) {
        	return array('error' => true, 'msg' => $this->getErrorMessage());
        }

        return array('error' => false);
	}

	/**
	 *
	 * Json içeriklerini temiz formata çekip döner.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param array $simplePage
	 * @return array 
	 *
	 */
	protected function setPageData($simplePage)
	{

		if ($this->checkImage() && !$this->checkDelete()) 
		{
	        $this->fileupload->setImageResize($this->getImage());
           	if ($this->fileupload->checkFile('image')) 
           	{
                $response = $this->fileupload->uploadImage('image');
                if ($response['error']) 
                {
                    $this->setErrorMessage($response['msg']);
                }
                else if(!$response['error'])
                {
                	$this->setImageData($response['data']);
                	$this->setImageDelete(true);
                	$this->setImageDataDelete(false);
                }
            }
		}

		if ($this->checkImageDelete()) {
			$this->fileupload->deleteImage($simplePage['image']);
		}

		if ($this->checkThumbnailDelete() && isset($simplePage['uploaded'])) {
			$this->fileupload->deleteImage($simplePage['uploaded']);
		}

		if ($this->checkImageDataDelete() || $this->checkEmptyCreateImage($simplePage)) {
			$this->setImageData(array());
		}

		foreach ($this->getDatas() as $pageKey => $pageValue) 
		{
			$simplePage[$pageKey] = $pageValue;
		}

		return $simplePage;
	}

	/**
	 *
	 * JSON verisini sayfa için temiz formata çevirir.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param object $pageData
	 * @return array 
	 *
	 */
	protected function pageFormat($pageData)
	{

		if (empty($pageData)) {
			return false;
		}

		$utility = new Utility();
		foreach ($pageData as $pageKey => $pageValue) 
		{

			if (isset($pageValue->description)) 
			{
				$pageValue->descriptionP = $utility->nl2P($pageValue->description);
			}

			if ($pageKey === 'thumbnail') 
			{

				$imagePath = false;
				if ($pageValue->selected !== false) 
				{
					
					$imagePath = new \StdClass();
					if ($pageValue->selected === 'uploaded') 
					{
						$imagePath->small  = $utility->getImageUrl($pageValue->uploaded->path, $pageValue->uploaded->images->small);
						$imagePath->big    = $utility->getImageUrl($pageValue->uploaded->path, $pageValue->uploaded->images->large);
					}
					else
					{
						$imagePath->small = $utility->getThemeImageUrl($pageValue->paths->small, $pageValue->images[$pageValue->selected]);
						$imagePath->big   = $utility->getThemeImageUrl($pageValue->paths->big, $pageValue->images[$pageValue->selected]);
					}

					$imagePath->exists = !($imagePath->small === $imagePath->big);

				}

				foreach ($pageValue->images as $imageKey => $imageValue) 
				{
					$pageValue->images[$imageKey] = new \StdClass();
					$pageValue->images[$imageKey]->key   = $imageKey;
					$pageValue->images[$imageKey]->small = $utility->getThemeImageUrl($pageValue->paths->small, $imageValue);
					$pageValue->images[$imageKey]->big   = $utility->getThemeImageUrl($pageValue->paths->big, $imageValue);
				}

				$pageValue->image = $imagePath;
				continue;
			}

			if ((is_array($pageValue) && isset($pageValue[0])) || (is_object($pageValue) && isset($pageValue->{0}))) 
			{
				$pageData->{$pageKey} = $this->pageFormat($pageValue);
				continue;
			}

			if (isset($pageValue->image)) 
			{
				$imageDefaultPath = isset($pageValue->image->images) ? $pageValue->image->path : '';
				$defaultImageSizes = array('small' => '', 'medium' => '', 'large' => '', 'original' => '');
				if (isset($pageValue->image->images)) {
					$defaultImageSizes = array_merge($defaultImageSizes, (array)$pageValue->image->images);
				}

				$images = new \StdClass();
				foreach ($defaultImageSizes as $imageSize => $imagePath) 
				{

					$path = $utility->getImagePath($imageDefaultPath, $imagePath);

					$images->{$imageSize} = (object) array(
						'exists' => !($path === false),
						'url'    => $utility->getImageUrl($imageDefaultPath, $imagePath),
						'path'   => $path
					);
				}

				if (is_array($pageData)) {
					$pageData[$pageKey]->image = $images;
				}else{
					$pageData->{$pageKey}->image = $images;
				}
			}
		}

		return ($pageData);
	}

}