<?php 
namespace ISProject\Models;

Class Clients extends \Phalcon\Mvc\Model
{

	private $db;

	private $prefix;

	public function onConstruct()
	{

		$this->db     = $this->di->getShared('db');
		$this->prefix = $this->getDI()->get('config')->database->prefix;

	}

	/**
	 *
	 * User Id numarasından kullanıcı bilgisini döner.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param string $degisken
	 * @return object 
	 *
	 */
	public function findUsersOfID($userId)
	{
		return $this->db->fetchOne("SELECT * FROM {$this->prefix}admins WHERE id = :id", \Phalcon\Db::FETCH_OBJ, array("id" => $userId));
	}

	/**
	 *
	 * Email adresinden kullanıcı bilgisini döner.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param string $email
	 * @return object 
	 *
	 */
	public function findAdminOfEmail($email)
	{
		return $this->db->fetchOne("SELECT * FROM {$this->prefix}admins WHERE email = :email", \Phalcon\Db::FETCH_OBJ, array("email" => $email));
	}

	/**
	 *
	 * Kullanıcı bilgilerini günceller.
	 *
	 * @author Ismail Satilmis <ismaiil_0234@hotmail.com>
	 * @param int $userID
	 * @param array $data
	 * @return boolean 
	 *
	 */
	public function updateUser($userID , $data = array())
	{

		$values = $query = array();

		if (isset($data["name"])) {
			array_push($query , "name = ?");
			array_push($values , $data["name"]);
		}

		if (isset($data["surname"])) {
			array_push($query , "surname = ?");
			array_push($values , $data["surname"]);
		}

		if (isset($data["email"])) {
			array_push($query , "email = ?");
			array_push($values , $data["email"]);
		}

		if (isset($data["password"]) && !empty($data["password"])) {
			array_push($query , "password = ?");
			array_push($values , $data["password"]);
		}

		if (count($values) <= 0) {
			return false;
		}

		array_push($values , $userID);
		return $this->db->execute("UPDATE {$this->prefix}admins SET " . implode(' , ' , $query) . " WHERE id = ?" , $values);

	}

}
