<div class="col-md-12">
	<div class="card rounded-0">

	  	<div class="card-header">
	    	<h4 class="card-title mb-0">Banner Alanı</h4>
	  	</div>

	  	<div class="card-body">

			{% for bannerId, banner in page.banner %}
			    <form method="POST" action="{{ site.admin.url }}index/banner" enctype="multipart/form-data">
			    	<input type="hidden" name="banner" value="{{ bannerId }}">
			      	<div class="row mb-3">
				        <div class="col-md-3 col-12">
				        	{{ partial('includes/placeholderimage', ['image': banner.image.medium, 'title': banner.title]) }}

							<div class="input-group mb-3">
								<div class="custom-file">
									<input type="file" class="custom-file-input" name="image">
									<label class="custom-file-label rounded-0 small">Dosya Seç</label>
								</div>
							</div>
				        </div>

				        <div class="col-md-9 col-12">
				            <div class="form-group">
							 	<label class="form-label font-weight-bold">Başlık</label>
								<input class="form-control rounded-0" maxlength="{{ site.charachter.min }}" name="title" value="{{ banner.title|escape }}">
							</div>			          
							<div class="form-group">
								<label class="form-label font-weight-bold">Açıklama</label>
								<textarea class="form-control rounded-0" rows="2" maxlength="{{ site.charachter.min }}" name="description">{{ banner.description|escape }}</textarea>
							</div>

					        <div class="form-group">
					        	<div class="custom-control custom-radio custom-control-inline">
								  <input type="radio" value="on" id="bannerAktif{{ bannerId }}" name="aktifpasif" {% if banner.active %}checked{% endif %} class="custom-control-input">
								  <label class="custom-control-label" for="bannerAktif{{ bannerId }}">Aktif</label>
								</div>
								<div class="custom-control custom-radio custom-control-inline">
								  <input type="radio" value="off" id="bannerPasif{{ bannerId }}" name="aktifpasif" {% if !banner.active %}checked{% endif %} class="custom-control-input">
								  <label class="custom-control-label" for="bannerPasif{{ bannerId }}">Pasif</label>
								</div>
					        </div>

							<div class="form-group text-md-right">
								<button type="submit" name="update" class="btn btn-success rounded-0 pl-5 pr-5 mb-md-0 ml-3 mb-3 float-right">Kaydet</button>
								<button type="submit" name="delete" class="btn btn-danger rounded-0 pl-5 pr-5 mb-md-0 mb-3">Temizle</button>
							</div>
				        </div>
			      	</div>
			    </form>
			{% endfor %}

	  	</div>
	</div>
</div>