{% set bannerCounter = 0 %}

<section class="slider mb-5">
  	<div id="carouselExampleCaptions" class="carousel slide" data-ride="carousel">
		<ol class="carousel-indicators">
		  	{% for index, banner in homepage.banner %}
		  		{% if banner.active %}
		  			<li data-target="#carouselExampleCaptions" data-slide-to="{{ index }}" class="{% if bannerCounter == 0 %}active{% endif %}"></li>
				  	{% set bannerCounter += 1 %}
		  		{% endif %}
		  	{% endfor %}
		</ol>
		<div class="carousel-inner">
			{% set bannerCounter = 0 %}
		  	{% for index, banner in homepage.banner %}
		  		{% if banner.active %}
				  	<div class="carousel-item {% if bannerCounter == 0 %}active{% endif %}">
						{{ partial('includes/placeholderimage', ['image': banner.image.large, 'placeholder': '1370x450', 'title': banner.title]) }}
						{% if banner.title OR banner.description %}
							<div class="carousel-caption d-none d-md-block">
							  	<h2 class="font-weight-bold clamp clamp-1">{{ banner.title|escape }}</h2>
							  	<p class="clamp clamp-2">{{ banner.description|escape }}</p>
							</div>
						{% endif %}
				  	</div>
				  	{% set bannerCounter += 1 %}
		  		{% endif %}
		  	{% endfor %}
		</div>
		<a class="carousel-control-prev" href="#carouselExampleCaptions" role="button" data-slide="prev">
		  	<span class="carousel-control-prev-icon" aria-hidden="true"></span>
		  	<span class="sr-only">Geri</span>
		</a>
		<a class="carousel-control-next" href="#carouselExampleCaptions" role="button" data-slide="next">
		  	<span class="carousel-control-next-icon" aria-hidden="true"></span>
		  	<span class="sr-only">İleri</span>
		</a>
  	</div>
</section>

<!-- Hizmetler Alanı -->

{% set activeHizmetler = 0 %}
{% for hizmet in hizmetler.hizmetler %}
	{% if hizmet.active %}
		{% set activeHizmetler += 1 %}
	{% endif %}
{% endfor %}

{% if site.general.pages.services.active and activeHizmetler > 0 %}
	<section class="services mb-5">
	  	<div class="container">
			<div class="row">
			  	<div class="col-md-12">
					<h3 class="box-title text-center font-weight-bold text-uppercase mb-4">Hizmetlerimiz</h3>
			  	</div>
			</div>

			<div class="row">
				{% set counterHizmet = 0 %}
				{% for index, hizmet in hizmetler.hizmetler %}
					{% if hizmet.active AND counterHizmet < 3 %}
					  	<div class="col-md-4 col-{% if index % 3 == 0 %}12{% else %}6{% endif %}">
							<div class="card text-white mb-3">
								{{ partial('includes/placeholderimage', ['image': hizmet.image.large, 'placeholder': '350x250', 'title': hizmet.title]) }}
							  	<div class="card-img-overlay">
									<div class="position-absolute title">
									  	<h5 class="card-title clamp clamp-1">{{ hizmet.title|escape }}</h5>
										<p class="card-text clamp clamp-2">{{ hizmet.description|escape }}</p>
									</div>
							  	</div>
							</div>
					  	</div>
					  	{% set counterHizmet += 1 %}
					{% endif %}
				{% endfor %}
			</div>
		</div>
	</section>
{% endif %}

<!-- Duyurular Alanı -->

{% set activeAnnouncement = 0 %}
{% for announcement in homepage.announcements %}
	{% if announcement.active %}
		{% set activeAnnouncement += 1 %}
	{% endif %}
{% endfor %}

<section class="information mb-5">
  	<div class="container">
		<div class="row">
			{% if activeAnnouncement > 0 %}
			  	<div class="col-md-{% if homepage.whyme.active %}6{% else %}12{% endif %} mb-5">
					<h3 class="box-title text-left font-weight-bold mb-4 text-uppercase">Duyurular</h3>
					{% for index, announcement in homepage.announcements %}
						{% if announcement.active %}
						
							<ul class="list-unstyled">
							  	<li class="media mb-3 cursor-pointer" data-fancybox="duyuru{{ index }}" data-src="#duyuru{{ index }}" href="javascript:;">
									{{ partial('includes/placeholderimage', ['image': announcement.image.small, 'placeholder': '80x80', 'title': announcement.title]) }}
									<div class="media-body ml-3">
									  	<h5 class="mt-0 mb-1 clamp clamp-1 font-weight-bold">{{ announcement.title|escape }}</h5>
									  	<p class="clamp clamp-2">{{ announcement.description|escape }}. 
									  	</p>
									</div>
							  	</li>
							</ul>

							<div id="duyuru{{ index }}" style="display: none; width:100%; max-width:660px;">

								<div class="text-center">
									{{ partial('includes/placeholderimage', ['image': announcement.image.large, 'placeholder': '600x400', 'title': announcement.title]) }}
									<hr>
								</div>

							    <h3 class="mb-3">{{ announcement.title|escape }}</h3>
							    <div class="description">
							    	{{ announcement.descriptionP }}
							    </div>

							</div>

						{% endif %}
					{% endfor %}
			  	</div>
		  	{% endif %}

		  	{% if homepage.whyme.active %}
			  	<div class="col-md-{% if activeAnnouncement == 0 %}12{% else %}6{% endif %}">
					<h3 class="box-title text-left font-weight-bold mb-4 text-uppercase">{{ homepage.whyme.title|escape }}</h3>
					<div class="home-text">
					  	{{ homepage.whyme.descriptionP }}
					</div>
			  	</div>
		  	{% endif %}
		</div>
  	</div>
</section>