<?php 

error_reporting(E_ALL);
ini_set('display_errors', 1);

include 'system/Defines.php';
include 'system/Input.php';
include 'system/Utility.php';
include 'system/Database.php';

$host             = $input->post('host');
$databasename     = $input->post('databasename');
$databaseusername = $input->post('databaseusername');
$databasepassword = $input->post('databasepassword');

$websitename      = $input->post('websitename');
$email            = $input->post('email');
$password         = $input->post('password');

if (empty($host) || empty($databasename) || empty($databaseusername) || empty($websitename) || empty($email) || empty($password)) {
	$utility->sendOutputJson(array('error' => true, 'msg' => 'Lütfen tüm alanları doldurunuz.'));
}

if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
	$utility->sendOutputJson(array('error' => true, 'msg' => 'Lütfen geçerli bir email adresi giriniz.'));
}

$database = new Database($host, $databasename, $databaseusername, $databasepassword);
if (!$database->isConnected()) {
	$utility->sendOutputJson(array('error' => true, 'msg' => 'Veritabanı bağlantısı başarısız. Lütfen veritabanı bilgilerinizi kontrol ediniz.'));
}

$database->dropTable('is_admins');
$database->dropTable('is_options');
$database->dropTable('is_pages');

$database->importDatabase(INSTALL_DATA_PATH . 'sql/Database.sql');

$database->addAdmin($email, $password);

$database->addOption('site_url', $utility->getWebsiteLink());
$database->addOptionJson('general', INSTALL_DATA_PATH . 'json/optionGeneral.json', array('companyname' => $websitename));
$database->addOptionJson('smtp'   , INSTALL_DATA_PATH . 'json/optionSmtp.json');

$pages = array('index', 'kurumsal', 'referanslar', 'hizmetler', 'galeri', 'urunler', 'iletisim');
foreach ($pages as $page) {
	$database->addPage($page, INSTALL_DATA_PATH . 'json/page' . ucfirst($page) . '.json');
}

$database->createConfigFile(CONFIG_PATH . 'config.php');

$utility->installFinished(INSTALL_PATH, time());
$utility->sendOutputJson(array('error' => false, 'redirect' => $utility->getWebsiteLink() . 'admin/'));
